/**
* Script: landstate.js
* Written by: Radnen
* Updated: 12/27/2010
**/

function EasyButton(text, x, y) {
	this.x = x;
	this.y = y;
	this.text = text;
	this.w = System.textFont.getStringWidth(text);
	this.h = System.textFont.getHeight();
	this.onClick = new Event(this);
	this.enabled = true;
	var entered = false;
	
	this.draw = function() {
		if (Cursor.isWithin(this.x, this.y, this.w, this.h)) {
			System.highlight.drawWindow(this.x-4, this.y-4, this.w+8, this.h+8);
			if (this.enabled) System.drawText(this.x, this.y, this.text, Colors.green);
			else System.drawText(this.x, this.y, this.text, Colors.darkGray);
		}
		else System.drawText(this.x, this.y, this.text);
	}
	
	this.update = function() {
		if (Cursor.isWithin(this.x, this.y, this.w, this.h)) {
			if (!entered) { entered = true; Audio.playSound(System.selectSnd); }
			if (this.enabled && Cursor.onLeftClick()) this.onClick.execute();
		}
		else entered = false;
	}
}

function LandState(planet, name)
{
	if (!name) name = "LandState";
	this.inherit = State;
	this.inherit(name);
	
	this.planet = planet;
	this.x = SW/2-250;
	this.y = SH/2-166;
	
	this.questitem = new EasyButton("Questlog", this.x + 100, this.y + 160);
	this.questitem.onClick.add(function(sender) {
		Audio.playSound(System.clickSnd);
		var queststate = new GetQuestState(sender.planet).show();
	}, this);
	this.shopitem = new EasyButton("Shop", this.x + 340, this.y + 160);
	this.shopitem.onClick.add(function(sender) {
		Audio.playSound(System.clickSnd);
		var shopstate = new ShopState(sender.planet).show();
	}, this);
	this.repairitem = new EasyButton("Repair/Refuel", this.x + 100, this.y + 260);
	this.repairitem.onClick.add(function() {
		Audio.playSound(System.clickSnd);
		var repairstate = new RepairState().show();
	});
	this.leaveitem = new EasyButton("Leave", this.x + 340, this.y + 260);
	this.leaveitem.onClick.add(function(sender) {
		Audio.playSound(System.cancelSnd);
		sender.hide();
	}, this);
	
	this.onEnter.add(function() {
		var i = Genesis.player.quests.length, q;
		while (i--) {
			q = Genesis.player.quests[i];
			if (q.finished) {
					if (q.planet == this.planet.name) {
					var queststate = new QuestFinishState(q);
					queststate.show();
					Genesis.player.quests.splice(i, 1);
					break;
				}
				if (q.type == QUEST_BOUNTY && q.system == Genesis.currentWorld) {
					var queststate = new QuestFinishState(q);
					queststate.show();
					Genesis.player.quests.splice(i, 1);
					break;
				}
			}
		}
		Genesis.player.updateEscortQuests(HATES_PLANET, this.planet.name);
	});
	
	this.render.add(function() {
		System.textFont.drawText(SW/2-System.textFont.getStringWidth(this.planet.name)/2, 16, this.planet.name);
		System.textFont.drawText(SW/2-System.textFont.getStringWidth("-"+this.planet.status+"-")/2, 32, "-"+this.planet.status+"-");
		Resources.images.landmenu.blit(this.x, this.y);
		SetClippingRectangle(this.x+20, this.y+12, 320, 116);
		Resources.images[this.planet.image].blit(this.x+20, this.y+12);
		SetClippingRectangle(0, 0, SW, SH);
		System.windowFont.drawTextBox(this.x+140, this.y+12, 360, 120, 0, "Welcome to " + this.planet.name +
		" please proceed to the docking bay and enjoy your stay, thank you.");
		
		this.questitem.draw();
		this.shopitem.draw();
		this.repairitem.draw();
		this.leaveitem.draw();
	});
	
	this.update.add(function() {
		this.questitem.update();
		this.shopitem.update();
		this.repairitem.update();
		this.leaveitem.update();
	});
	
	this.doInput = function(key) {
		switch (key) {
			case KEY_ESCAPE:
			case KEY_SHIFT:
				this.hide();
			break;
		}
	}
}